<?= helper('form'); ?>
<div class="main-content">

    <section class="section">
        <div class="section-header">
            <h1><?= labels('withdrawal_requests', 'Withdrawal Requests') ?></h1>
            <div class="section-header-breadcrumb">
            <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>"> <i class="fas fa-home-alt text-danger"></i><?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/partner/withdrawal_requests/send') ?>"><?= labels('send_withdrawal_request', 'Send withdrawal request') ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('list_of_withdrawal_requests', "List of Withdrawal Requests") ?></h2>
                </div>
                <div class="col-md text-right m-auto">
                    <a class="btn btn-primary text-white" id="add_promo" href="<?= base_url('partner/withdrawal_requests/send'); ?>"><i class="fas fa-plus"></i> <?= labels('send_withdrawal_request', 'Send Request') ?></a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered table-hover"
                    data-query-params="withdraw_request_query" 
                    data-detail-formatter="detailFormatter"
                     id="withdrawal_requests_table" data-auto-refresh="true" 
                     data-show-columns="true" 
                     data-show-refresh="true" data-toggle="table" data-search-highlight="true"
                     data-server-sort="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" 
                     data-url="<?= base_url("partner/withdrawal_requests/list") ?>" data-side-pagination="server" 
                     data-pagination="true" data-search="true" data-sort-name="p.id" data-sort-order="DESC">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="payment_address" class="text-center" data-visible="true" ><?= labels('payment_address', 'Payment Address') ?></th>
                                <th data-field="amount" class="text-center" data-visible="true" ><?= labels('amount', 'Amount') ?></th>
                                <th data-field="remarks" class="text-center" data-visible="false"><?= labels('remarks', 'Remarks') ?></th>
                                <th data-field="status" class="text-center" data-visible="true"><?= labels('status', 'Status') ?></th>
                                <th data-field="created_at" class="text-center" data-visible="false"><?= labels('created_at', 'Created at') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
</div>
</div>
</div>
</section>
</div>
<div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Promo Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= form_open('partner/withdrawal_Requests/save', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'withdrawal_request_form', 'enctype' => "form-data"]); ?>
                <input type="hidden" name="request_id" id="request_id">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="payment_address"><?= labels('payment_address', 'Payment Address') ?></label>
                            <textarea class="form-control" name="payment_address" id="payment_address" cols="50" rows="10"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 ">
                        <div class="form-group">
                            <label for="amount"><?= labels('amount', 'Amount') ?></label>
                            <input type="text" class="form-control" id="amount" name="amount">
                            <input type="hidden" class="form-control" id="user_id" name="user_id" value="<?= !empty($partnerId) ? $partnerId : "" ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Save changes</button>
                <?php form_close() ?>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>